# 语音合成 Android SDK 开发文档

**添加aar依赖**

将 `android-tts-sdk-release-V1.0.0.0.aar` 放入项目的 `libs` 目录内，修改 `app` 模块的 `build.gradle` ，将 aar 文件与okhttp添加为依赖。

```java
implementation fileTree(dir:"libs",include:["*.jar","*.aar"])
implementation'com.squareup.okhttp3:okhttp:4.9.0'
 ```

#### 添加应用相关权限

修改AndroidManifest.xml文件

 ```xml
<!--网络权限-->
<uses-permission android:name="android.permission.INTERNET" />
```

## 调用步骤/示例代码

### 1. 获取实例

#### ⑴ 创建合成类

```java
     Tts tts=Tts.getInstance(this,((code,msg)->{
        if("00000".equals(code)){
        System.out.println("成功");
        }else{
        Toast.makeText(this,msg,Toast.LENGTH_SHORT).show();
        }
      }));  
```

#### ⑵ 设置回调

（1）回调参数说明
|名称|类型|说明|返回参数|
|-------|-------|-------|-------|
|onStart|Function|引擎连接开始的回调方法|String类型 当前任务的id|
|onWarning|Function|引擎返回结果警告回调方法 |任务id和Errors类型状态码|
|onError|Function|引擎返回结果错误回调方法|任务id和Errors类型状态码|
|onPlayStart|Function|引擎返回播放开始回调方法|无|
|onPlayFinish|Function|引擎返回合成结束的回调方法|无|
|onGetAudio|Function|引擎返回合成音频数据回调方法|byte[]类型音频数据|
|onSynthesisTimestamp|Function|引擎返回时间戳和声韵母回调方法|JsonObject|
|onStop|Function|引擎返回播放结束回调方法|无|
（2）参数实例

```java
tts.setListener(new Tts.Listener(){
@Override
public void onStart(String taskId){}

@Override
public void onStop(){}

@Override
public void onError(String taskId,ErrorCodes.ErrorCode err){}

@Override
public void onGetAudio(byte[]data){}

@Override
public void onPlayStart(){}

@Override
public void onPlayFinish(){}

@Override
public void onSynthesisTimestamp(JsonObject payload){}

@Override
public void onWarning(String taskId,ErrorCodes.ErrorCode err){}

        });


```

### 3. 参数设置


| **参数**                 | 类型    | **是否必需** | **说明**                                                     | 默认值  |
| ------------------------ | ------- | ------------ | ------------------------------------------------------------ | ------- |
| text                     | String  | 是           | 待合成文本，长度限制：1024字节（UTF-8编码） | 无   |
| text_type | String | 否 | plain | plain |
| lang_type                | String  | 是           | 语种选项，参见[开发指南-语言和音色支持](#/help?url=tts/guidance.md) | 无   |
| voice                    | String  | 否           | 音色代码，参见[开发指南-语言和音色支持](#/help?url=tts/guidance.md) | 日语：Xiaohui<br>英语：Julie<br>中文：Xiaohui |
| sample_rate | Integer | 否 | 音频采样率，可选8000，16000，24000 | 24000 |
| format                   | String  | 否           | 音频编码格式，wav / pcm / mp3，<br>注意：wav 不支持流式 | pcm     |
| compression_rate | Integer | 否           | opus格式时编码压缩比，参数范围 [1, 20] | 1  |
| speech_rate | Float | 否 | 语速，参数范围 [0.2,3]，通常保留一位小数即可 | 1 |
| volume                   | Float | 否           | 音量，参数范围 [0.1, 3]，通常保留一位小数即可 | 1     |
| pitch_rate               | Float   | 否           | 语调，以 [-1.0, 1.0] 范围内的数字表示的八度音程，-1.0 表示低八度，1.0 表示高八度 | 0       |
| emotion  | String | 否           | 情感/风格，参见[开发指南-语言和音色支持](#/help?url=tts/guidance.md) | 无  |
| silence_duration | Integer | 否           | 句尾静音时长，单位为ms | 125 |
| enable_timestamp | Boolean | 否 | 时间戳相关，传入true时表示启用，可返回原文本的时间戳，而非TN后文本，即保留原文中的阿拉伯数字或者特殊符号等。注意：原文本中的多个标点连用或者空格依然会被处理，但不影响时间戳连贯性 | false |
| enable_english_opt | Boolean | 否 | 英文前端优化，传入true时表示启用，启用后中文音色读纯英文时可以正确处理文本中的阿拉伯数字 | false |


```java
   Tts.Params params=tts.getParams();
        params.setText(text);
        params.setSampleRate(24000);
        params.setFormat("pcm");
        params.setLang("zh-cmn-Hans-CN");

```

### 4. 开始/停止合成

```java
tts.start();
tts.stop(); 
```

